/*
 * Toolkit GUI, an application built for operating pinkRF's signal generators.
 *
 * Contact: https://www.pinkrf.com/contact/
 * Copyright © 2018-2024 pinkRF B.V
 * GNU General Public License version 3.
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License along with this program. If not, see https://www.gnu.org/licenses/
 *
 * Author: Iordan Svechtarov
 */

#ifndef SERIAL_V3_H
#define SERIAL_V3_H
#include <QThread>
#include <QtSerialPort/QSerialPort>

class Serial : public QObject
{
	Q_OBJECT

private:

	QString	serialportName_ref;
	QString	intrasys_number;
	bool console_output_enabled;

public:

	Serial();
	QSerialPort	*serial;

	//CORE Functions
	void setup(QString portname, QString channel_number);
	bool open();
	void close();
	void serialClearBuffer();
	QString	writeRead(QString tx);
	QString writeReadOK(QString tx, int timeout_ms);
	void serialWrite(QString tx);
	bool serialRead(QString& rx, int timeout_ms = 1000);
	bool serialReadOK(QString& rx, int timeout_ms);

	//Remote Command Mode
	void RCM_Write(QString tx);
	QString RCM_Read();
};


#endif // SERIAL_V3_H
